//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
#include "stdafx.h"
#include "SynchTcpTest.h"

SynchronousTcpTest::SynchronousTcpTest(const std::string& _server, int _port, int _numberOfPackets, int _packetSize) :
        NetworkTest(_server, _port, _numberOfPackets, _packetSize)
{
   socket = WSASocket(AF_INET, SOCK_STREAM, 0, NULL, 0, 0);
   if (socket == INVALID_SOCKET)
   {
      return;
   }

   sin.sin_family = AF_INET;
   sin.sin_addr.s_addr = inet_addr(server.c_str());
   if(sin.sin_addr.s_addr == INADDR_NONE)
   {
		LPHOSTENT lpHost = ::gethostbyname(server.c_str());
		if(lpHost != NULL)
		{
            // ::CopyMemory(&sin.sin_addr, lpHost->h_addr_list[0],
		    //             lpHost->h_length);
			sin.sin_addr.s_addr = 
				    ((LPIN_ADDR)lpHost->h_addr)->s_addr;
		}
		else
		{
	        std::string strError;
	        ReportSocketError("connect", strError);
	        ::closesocket(socket);
	        socket = INVALID_SOCKET;
			return;
		}
   }

   sin.sin_port = htons((u_short)port);

   if (::WSAConnect(socket, (LPSOCKADDR) &sin, sizeof (SOCKADDR_IN), NULL, NULL, NULL, NULL) != 0)
   {
	  std::string strError;
	  ReportSocketError("connect", strError);
	  ::closesocket(socket);
	  socket = INVALID_SOCKET;
      return;
   }
}

SynchronousTcpTest::~SynchronousTcpTest()
{
}

int SynchronousTcpTest::Start()
{
	int         nTotalReceived, nReceived, nBytes;
	LPBYTE      lpszBuffer;
	DWORD       dwStartTime, dwEndTime;
	int        i;
	DWORD       dwBytesTransmitted = 0;

	if(socket == INVALID_SOCKET)
		return 0;

	lpszBuffer = new BYTE[packetSize];

	// Wysanie losowego pakietu
	nBytes = ::send(socket, (LPCSTR) lpszBuffer, 100, 0);

	for (nTotalReceived = nReceived = 0;
		nBytes != SOCKET_ERROR &&
		nTotalReceived < nBytes;)
	{
		nReceived = ::recv(socket, (LPSTR) lpszBuffer, nBytes, 0);
		if (nReceived != SOCKET_ERROR)
		{
			nTotalReceived += nReceived;
		}
	}

	transmitByteCount = 0;
	receivedByteCount = 0;
	for (i = 0, dwStartTime = ::GetCurrentTime();
		i < numberOfPackets; ++i)
	{
	    nBytes = ::send(socket, (LPCSTR) lpszBuffer, packetSize, 0);
		if (nBytes != SOCKET_ERROR)
		{
			transmitByteCount += nBytes;
			for (nReceived = 0, nTotalReceived = 0;
				 nTotalReceived < nBytes; )
			{
				if ((nReceived = ::recv(socket, (LPSTR) lpszBuffer, nBytes, 0)) == SOCKET_ERROR)
					break;
				nTotalReceived += nReceived;
			}
			receivedByteCount += nTotalReceived;
		}
	}
	dwEndTime = ::GetCurrentTime();

	elapsed = dwEndTime - dwStartTime;

	delete [] lpszBuffer;

	::closesocket(socket);
	socket = INVALID_SOCKET;

	return transmitByteCount + receivedByteCount;
}

UNMANAGEDNETWORKING_API void SynchTcpTest(LPCSTR server, int port, int count, int size)
{
	extern NetworkTest *pNetworkTest;

	if(pNetworkTest)
		delete pNetworkTest;

	pNetworkTest = new SynchronousTcpTest(server, port, count, size);

}
